/*------------------------------------------------------------------------------*
 * File Name: XFWiz.h															*
 * Creation: Sim 03-20-2007														*
 * Purpose: Origin C Header Files												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Sim 08-26-2008 QA80-12093 REUSE_REPORT_DATA_IN_XFWIZ_WHEN_RECALCULATE		*
 *	Sim 10-13-2008 NEW_PA_81_THEME_FILTER_SETTING								*
 *	Sophy 10/28/08 QA80-12442 SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE				*
 *	Sim 11-14-2008 SUPPORT_PA_THEME_SR4_CONVERT_TO_SR5							*
 *	Sim 11-17-2008 FIX_SAVE_SHARED_VALUE_ON_PA_WIZ_THEME_TREE					*
 *	Folger 12/10/08 v8.0984d REMOVE_ANALYSIS_MARKER_WHEN_CLICK_CANCEL_IN_WIZARD	*
 *	Sim 12-29-2008 QA80-12798 XF_WIZ_THEME_COMPARE								*
 *	Sim 01-12-2009 QA80-12946 XFWIZ_SUPPORT_CHANGE_RECALCULATE_MODE				*
 *	Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE				*
 *	Sim 01-14-2009 FIX_XFWIZ_OP_DISPLAY_THEME_NAME								*
 *	Sim 01-14-2009 FIX_XFWIZ_COMPARE_DEFAULT_THEME_MISS_DEFAULT_STEPS			*
 *	Folger 08/07/09 QA80-13998-P1 OUTPUT_RANGE_LT_STRING_FAILS_TO_UPDATE_WHEN_RUN_PA_WITHOUT_AUTOUPDATE
 *	Folger 11/03/09 BETTER_CHECKING_FOR_RUNNING_PA_FROM_AUTO_UPDATE				*
 *	Sim 01-07-2009 QA81-14898 SHOW_GUI_SETTINGS_FOR_XFWIZ_OPERATION				*
 *------------------------------------------------------------------------------*/

#ifndef __XF_WIZ_H__
#define __XF_WIZ_H__

#include <Array.h>

enum
{
	APPLY_RULE_INPUT = 0x0001,
	APPLY_RULE_OUTPUT = 0x0002,
};

class XFWizInputOutputRange
{
public:
	///---Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
	XFWizInputOutputRange();
	XFWizInputOutputRange(const TreeNode& trInputsOutputs);
	///---END XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
public:
	bool		SetTree(const TreeNode& trInputsOutputs);
	bool		GetTree(Tree& trInputsOutputs);
	
	bool		Apply(TreeNode& trGetN, LPCSTR lpcszXFName, DWORD dwCtrl = APPLY_RULE_INPUT|APPLY_RULE_OUTPUT);
	
	void		Reset();
	//bool		Add(const DataRange& dr, LPCSTR lpcszXFName, LPCSTR lpcszVar, bool bInput);
	//bool		Get(int nIndex, DataRange& dr, string& strXFName, string& strVar, bool bInput);
	bool		Add(const Array<DataRange&> *parrdr, LPCSTR lpcszXFName, bool bInput, bool bUpdateExisting = true);
	bool		Get(Array<DataRange&> *parrdr, LPCSTR lpcszXFName, bool bInput);
	
	///---Sim 08-26-2008 QA80-12093 REUSE_REPORT_DATA_IN_XFWIZ_WHEN_RECALCULATE
	bool		GetUIDs(vector<int>& vUIDs, LPCSTR lpcszXFName, bool bInput);
	///---END QA80-12093 REUSE_REPORT_DATA_IN_XFWIZ_WHEN_RECALCULATE
	
	bool		SetTargetPage(const Page& pg);
	bool		GetTargetPage(Page& pg);
	
	//void		SetAsOperationOwner(bool bOpOwner);
	//bool		IsOperationOwner();
	
	//------ Folger 12/10/08 v8.0984d REMOVE_ANALYSIS_MARKER_WHEN_CLICK_CANCEL_IN_WIZARD
	void		RemoveAllRangesAnalysisMarkers();
	//------
	
	///---Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
	void		ClearAll();
	///---END XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE

	///------ Folger 08/07/09 QA80-13998-P1 OUTPUT_RANGE_LT_STRING_FAILS_TO_UPDATE_WHEN_RUN_PA_WITHOUT_AUTOUPDATE
	virtual		void		UpdateOutputsGlobalRangeStrings(LPCSTR lpcszXFName)	{ }
	///------ End OUTPUT_RANGE_LT_STRING_FAILS_TO_UPDATE_WHEN_RUN_PA_WITHOUT_AUTOUPDATE
	
protected:
	void		SetRangeTree(const TreeNode& trRanges, const TreeNode& trInfos, bool bInput);
	void		GetRangeTree(TreeNode& trRanges, TreeNode& trInfos, bool bInput);
	
	//bool		ApplyRange(TreeNode& trGetN, LPCSTR lpcszXFName, bool bInput);
	//bool		GetInput(int& nInputUID, LPCSTR lpcszXFName);
	//bool		GetOutputs(vector<int>& vOutputUIDs, LPCSTR lpcszXFName);
	///---Sim 08-26-2008 QA80-12093 REUSE_REPORT_DATA_IN_XFWIZ_WHEN_RECALCULATE
	// move to public
	//bool		GetUIDs(vector<int>& vUIDs, LPCSTR lpcszXFName, bool bInput);
	///---END QA80-12093 REUSE_REPORT_DATA_IN_XFWIZ_WHEN_RECALCULATE
	
	bool		AddRange(const DataRange& dr, LPCSTR lpcszXFName, bool bInput, bool bReUseUID = false);
	bool		GetRange(int nIndex, DataRange& dr, string& strXFName, bool bInput);
	bool		UpdateRange(int nIndex, const DataRange& dr, LPCSTR lpcszXFName, bool bInput);
	bool		RemoveRange(int nIndex, bool bInput);
	
	DataRange*	NewRange(const DataRange& dr, bool bCreateUID = false);
	DataRange&	GetRange(int nIndex, bool bInput);
protected:
	Array<DataRange&>	m_drInputs;
	StringArray		m_saInputXFNames;
	//StringArray		m_saInputVars;
	
	Array<DataRange&>	m_drOutputs;
	StringArray		m_saOutputXFNames;
	//StringArray		m_saOutputVars;
	
	Page			m_pgTarget;
	//bool			m_bOpOwner;
};

enum{
	SUCCESS_APPLY_THEME,
	NONE_THEME,
	FAILED_APPLY_THEME,
};

class XFWizTheme
{
public:
	XFWizTheme();
	///---Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
	XFWizTheme(const TreeNode& trThemes);
	///---END XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
public:
	///---Sim 11-17-2008 FIX_SAVE_SHARED_VALUE_ON_PA_WIZ_THEME_TREE
	//bool		SetTree(const TreeNode& trThemes);
	virtual bool		SetTree(const TreeNode& trThemes);
	///---END FIX_SAVE_SHARED_VALUE_ON_PA_WIZ_THEME_TREE
	bool		GetTree(Tree& trThemes);
	
	///---Sim 10-13-2008 NEW_PA_81_THEME_FILTER_SETTING
	virtual	bool		IsThemeSettingSupported() {return false;}
	virtual string		GetThemeFilterDlgTitle() {ASSERT(FALSE); return "";}
	bool		SetThemeFilterTree(const TreeNode& trThemeFilter);
	bool		GetThemeFilterTree(TreeNode& trThemeFilter);
	///---END NEW_PA_81_THEME_FILTER_SETTING

	bool		GetXFList(StringArray& saXFs);
	bool		SetXFList(const StringArray& saXFs);
	
	///---Sim 01-14-2009 FIX_XFWIZ_COMPARE_DEFAULT_THEME_MISS_DEFAULT_STEPS
	void SetDefaultSteps(const StringArray& saDefaultXFNames);
	///---END FIX_XFWIZ_COMPARE_DEFAULT_THEME_MISS_DEFAULT_STEPS
	
	//virtual int			Apply2GetN(TreeNode& trGetN, LPCSTR lpcszXFName);
	//virtual int			UpdateFromGetN(const TreeNode& trGetN, LPCSTR lpcszXFName);
	virtual int			Update(const TreeNode& trGetN, LPCSTR lpcszXFName, bool bToGetN);
	
	void		SetClassName(LPCSTR lpcszClassName);
	///---Sim 11-17-2008 FIX_SAVE_SHARED_VALUE_ON_PA_WIZ_THEME_TREE
	//bool		Load(LPCSTR lpcszThemeName);
	virtual bool		Load(LPCSTR lpcszThemeName);
	///---END FIX_SAVE_SHARED_VALUE_ON_PA_WIZ_THEME_TREE
	bool		Save(LPCSTR lpcszThemeName);
	
	bool		IsEmpty();
	
	void		SetVersion(double dVersion);
	double		GetVersion();
	
	///------ Folger 11/03/09 BETTER_CHECKING_FOR_RUNNING_PA_FROM_AUTO_UPDATE
	//void		SetHookOperation(bool bIsHooked = true);
	//bool		IsHookOperation();
	///------ End BETTER_CHECKING_FOR_RUNNING_PA_FROM_AUTO_UPDATE
	
	bool		IsFromFile(string& strFileName);
	void		ClearRuntimeInfo();
	string		GetThemeFileName(LPCSTR lpcszThemeName);///Sophy 10/28/08 QA80-12442 SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE move from protected
	
	///---Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
	int			GetAutoUpdateMode();
	void		SetAutoUpdateMode(int nAutoUpdate);
	///---END XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
	
	///---Sim 01-14-2009 FIX_XFWIZ_OP_DISPLAY_THEME_NAME
	void		ClearThemeName();
	///---END FIX_XFWIZ_OP_DISPLAY_THEME_NAME
	
	bool		CompareTheme(XFWizTheme *pXFWizTheme, TreeNode& trDiff); ///---Sim 12-29-2008 QA80-12798 XF_WIZ_THEME_COMPARE
	///---Sim 12-29-2008 QA80-12798 XF_WIZ_THEME_COMPARE wait Tarak fix
	// need move to protected, wait for OC good class mechanism support
	void		UpdateSetting();
	TreeNode	GetPath(bool bCheckAddNode = false);
	TreeNode	GetXFTheme(LPCSTR lpcszXFName, bool bCheckAddNode = false);
	TreeNode	GetShared(bool bCheckAddNode = false);
	TreeNode	GetThemeFilter(bool bCheckAddNode = false);
	///---END QA80-12798 XF_WIZ_THEME_COMPARE
protected:
	///---Sim 12-29-2008 QA80-12798 XF_WIZ_THEME_COMPARE wait Tarak fix
	// I don't understand why it can't be invoked by another object of same class
	// It work fine in VC++
	//void		UpdateSetting();
	///---END QA80-12798 XF_WIZ_THEME_COMPARE
	
	bool		DefaultTheme(int nOp);
	bool		LoadFile(LPCSTR lpcszThemeName);
	bool		SaveFile(LPCSTR lpcszThemeName);
	
	///---Sim 12-29-2008 QA80-12798 XF_WIZ_THEME_COMPARE wait Tarak fix
	// I don't understand why it can't be invoked by another object of same class
	// It work fine in VC++
	//TreeNode	GetXFTheme(LPCSTR lpcszXFName, bool bCheckAddNode = false);
	////string		GetThemeFileName(LPCSTR lpcszThemeName);///Sophy 10/28/08 QA80-12442 SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE move to public
	//
	//TreeNode	GetShared(bool bCheckAddNode = false);
	///---END QA80-12798 XF_WIZ_THEME_COMPARE
	
	double		GetVersion(TreeNode& trThemes);
	bool		CheckVersion(double dVer, double dRefVer, LPCSTR lpcszThemeName);
	
	///---Sim 11-14-2008 SUPPORT_PA_THEME_SR4_CONVERT_TO_SR5
	bool		CheckLoad(TreeNode& trThemes, LPCSTR lpcszThemeName);
	///---END SUPPORT_PA_THEME_SR4_CONVERT_TO_SR5
	
	//bool		IsDefault(LPCSTR lpcszThemeName);
	
	///---Sim 10-13-2008 NEW_PA_81_THEME_FILTER_SETTING
	virtual	bool		ConstructThemeFilter(TreeNode& trThemeFilter) {return false;}
	virtual bool		GetThemeFilterMapIDs(vector<int>& vnGUIID, vector<int>& vnThemeFilterID, TreeNode& trGetN, LPCSTR lpcszXFName) {return false;}
	
	///---Sim 12-29-2008 QA80-12798 XF_WIZ_THEME_COMPARE wait Tarak fix
	// I don't understand why it can't be invoked by another object of same class
	// It work fine in VC++
	//TreeNode	GetThemeFilter(bool bCheckAddNode = false);
	///---END QA80-12798 XF_WIZ_THEME_COMPARE
	void		UpdateThemeFilterEdition();
	///---END NEW_PA_81_THEME_FILTER_SETTING
	
	///---Sim 11-14-2008 SUPPORT_PA_THEME_SR4_CONVERT_TO_SR5
	virtual bool		ConvertVersion(TreeNode& trThemes);
	///---END SUPPORT_PA_THEME_SR4_CONVERT_TO_SR5
	
	bool		UpdateSharedValues(TreeNode& trGetN, bool bToGetN); ///---Sim 01-12-2009 QA80-12946 XFWIZ_SUPPORT_CHANGE_RECALCULATE_MODE
private:
	///---Sim 12-29-2008 QA80-12798 XF_WIZ_THEME_COMPARE
	bool		comparePath(XFWizTheme *pXFWizTheme, TreeNode& trDiff, vector<string> &vsPathCommon);
	bool		compareShared(XFWizTheme *pXFWizTheme, TreeNode& trDiff);
	bool		compareFilter(XFWizTheme *pXFWizTheme, TreeNode& trDiff);
	bool		compareXFs(const vector<string> &vsPathCommon, XFWizTheme *pXFWizTheme, TreeNode& trDiff);
	///---END QA80-12798 XF_WIZ_THEME_COMPARE
	
protected:
	Tree		m_trThemes;
	string		m_strClassName;
	double		m_dVersion;
	
	StringArray		m_saSharedList; ///---Sim 01-12-2009 QA80-12946 XFWIZ_SUPPORT_CHANGE_RECALCULATE_MODE
	
	///---Sim 10-13-2008 NEW_PA_81_THEME_FILTER_SETTING
	Tree		m_trLoadedThemeFilter;	// this is original theme filter in theme file, it is used to load theme to trGetN tree,
										// as another same one in dialog(trGetN tree) can be changed by GUI and isn't reliable for load theme
	///---END NEW_PA_81_THEME_FILTER_SETTING
	
	///---Sim 01-14-2009 FIX_XFWIZ_COMPARE_DEFAULT_THEME_MISS_DEFAULT_STEPS
	StringArray		m_saDefaultXFNames;
	///---END FIX_XFWIZ_COMPARE_DEFAULT_THEME_MISS_DEFAULT_STEPS
};


/*
enum{
	XFWIZ_RUN_MODE_SCRIPT,
	XFWIZ_RUN_MODE_DLG,
	XFWIZ_RUN_MODE_RECALCULATE,
	XFWIZ_RUN_MODE_CHANGE_PARAM,
}
struct XFWizRunModel
{
	int nMode;
	HWND hWnd;
};
*/
struct XFMODE
{
	int			nXFType;
	DWORD		dwXFMode;
	DWORD		dwExecute;
	int			nAddRecalculate;
	int			nAddResultsLogOutput;
};
class XFWizRunModelBase
{
public:
	XFWizRunModelBase() {}
public:
	virtual bool	UpdateSteps(const StringArray &saSteps) {return true;}
	virtual bool	ActiveStep(int nStep) {return true;}
	virtual void	SetPageEventLink(bool bTurnOn) {}
	virtual bool	OnAfterLoadXF()  {return true;}
	virtual bool	OnUndoXF() {ASSERT(FALSE); return false;}
	virtual void	Close(int nModalRet = -1) {}

public:
	///---Sim 01-07-2009 QA81-14898 SHOW_GUI_SETTINGS_FOR_XFWIZ_OPERATION
	bool			IsNoCall() { return (LTXF_NO_CALL & m_stXFMode.dwExecute); }
	///---END QA81-14898 SHOW_GUI_SETTINGS_FOR_XFWIZ_OPERATION
public:
	XFMODE		m_stXFMode;
};

///---Sim 06-02-2009 QA80-4584 EXTRACT_WKS_SUPPORT_AUTO_UPDATE
//#define STR_NODE_NAME_AUTO_UPDATE		"AutoUpdate" ///---Sim 01-12-2009 QA80-12946 XFWIZ_SUPPORT_CHANGE_RECALCULATE_MODE
#define STR_NODE_NAME_AUTO_UPDATE		STR_AUTO_UPDATE
///---END QA80-4584 EXTRACT_WKS_SUPPORT_AUTO_UPDATE

bool error_report_to_user_and_developer(LPCSTR lpcszErr);

#endif		//__XF_WIZ_H__